﻿/*
REQUIRES:
	LOOP system  (for optional "onEnterFrame" events)
	onUnload() must be available
	
NOTES:
	To react to onUnload() while using this, use this instead:
		react.to("unload").then ...
*/
function runFunc( func ){
	return func.apply( _this, arguments.slice() );
}// runFunc()


// events
#include "functions/eventSystem3.as"
#include "functions/sendEvent.as"
#include "gameFunctions/callUnload.as"
if( !_listeners  ){
	AsBroadcaster.initialize(_this);
}
react = make_react( _this );


onUnload = function(){
	delete _this.onUnload;		// allow instant removeMovieClip() after this.
	callUnload( _this );
}// onUnload()


// create "onEnterFrame" event
runFunc(function(){
	if(!LOOP)		return;
	var loopObj = {};
	loopObj.loop = function(){
		sendEvent("onEnterFrame");
	}// loop()
	LOOP.addObject( loopObj, "always" );
	react.to("unload").then = function(){
		LOOP.removeObject( loopObj, "always" );
	}
});